/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.client.capture.palettizer;

import io.github.mortuusars.exposure.client.capture.palettizer.DitheredPalettizer;
import io.github.mortuusars.exposure.client.capture.palettizer.NearestColorPalettizer;
import io.github.mortuusars.exposure.client.image.Image;
import io.github.mortuusars.exposure.client.image.PalettedImage;
import io.github.mortuusars.exposure.data.ColorPalette;
import io.github.mortuusars.exposure.world.camera.capture.ProjectionMode;
import java.util.function.Function;

public interface Palettizer {
    public static final Palettizer NEAREST = new NearestColorPalettizer();
    public static final Palettizer DITHERED = new DitheredPalettizer();

    public PalettedImage palettize(Image var1, ColorPalette var2);

    default public PalettedImage palettizeAndClose(Image image, ColorPalette palette) {
        PalettedImage palettedImage = this.palettize(image, palette);
        image.close();
        return palettedImage;
    }

    default public Function<Image, PalettedImage> palettizeAndClose(ColorPalette palette) {
        return image -> this.palettizeAndClose((Image)image, palette);
    }

    public static Function<Image, PalettedImage> palettizeAndClose(Palettizer palettizer, ColorPalette palette) {
        return image -> palettizer.palettizeAndClose((Image)image, palette);
    }

    public static Palettizer fromProjectionMode(ProjectionMode mode) {
        return mode == ProjectionMode.DITHERED ? DITHERED : NEAREST;
    }
}

